/* Antarmuka dengan LED, Buzzer dan Relay - Trainer Internet of Things
 * Project : Mengontrol Device dengan Aplikasi IoT KIT
 * Created By Electins.id
 * https://www.electins.id | https://www.instagram.com/electins.id/
 */

// Library ESP8266 WiFi dan Firebase ESP8266
#include <ESP8266WiFi.h>
#include <FirebaseESP8266.h>

// SSID dan Password WiFi
#define WIFI_SSID "SSID_WIFI"
#define WIFI_PASSWORD "PASS_WIFI"

// URL Firebase dan Token Database
#define DATABASE_URL "project_id.firebaseio.com"
#define API_KEY "database_secret"

// Firebase objek dengan nama fbdo
FirebaseData fbdo;
// Nama pengguna pada Aplikasi IoT KIT
String user = "user_id";

// PIN LED, Buzzer dan relay
#define LED_PIN   D0
#define BUZZ_PIN  D1
#define RELAY_PIN D2

void setup() {
  // Serial Monitor pada baudrate 115200
  Serial.begin(115200);

  // Mengatur PIN LED, Buzzer dan Relay sebagai OUTPUT
  pinMode(LED_PIN,  OUTPUT); 
  pinMode(BUZZ_PIN, OUTPUT); 
  pinMode(RELAY_PIN,OUTPUT); 

  // Memulai koneksi WiFi
  WiFi.begin(WIFI_SSID, WIFI_PASSWORD);
  Serial.print("Connecting to Wi-Fi");
  while (WiFi.status() != WL_CONNECTED)
  {
    Serial.print(".");
    delay(300);
  }
  // Menampilkan status koneksi dan alamat IP
  Serial.println();
  Serial.print("Connected with IP: ");
  Serial.println(WiFi.localIP());
  Serial.println();
  
  // Menampilkan versi client firebase
  Serial.printf("Firebase Client v%s\n\n", FIREBASE_CLIENT_VERSION);
  // Memulai koneksi dengan dengan database
  // Re-koneksi jika WiFi terputus
  Firebase.begin(DATABASE_URL, API_KEY);
  Firebase.reconnectWiFi(true);
}

void loop() {
  // Membaca database pada alamat */user/switch1
  // Jika bernilai true LED ON
  // Jika bernilai false LED OFF
  if(Firebase.getString(fbdo, "/" + user +  "/switch1")) {
    if(fbdo.to<bool>() == true){
      digitalWrite(LED_PIN, HIGH);
      Serial.println("LED On");
    }else{
      Serial.println("LED Off");
      digitalWrite(LED_PIN, LOW);
    }
  }
  // Membaca database pada alamat */user/switch2
  // Jika bernilai true Buzzer ON
  // Jika bernilai false Buzzer OFF
  if(Firebase.getString(fbdo, "/" + user + "/switch2")) {
    if(fbdo.to<bool>() == true){
      digitalWrite(BUZZ_PIN, HIGH);
      Serial.println("Buzzer On");
    }else{
      Serial.println("Buzzer Off");
      digitalWrite(BUZZ_PIN, LOW);
    }
  }
  // Membaca database pada alamat user/switch3
  // Jika bernilai true Relay ON
  // Jika bernilai false Relay OFF
  if(Firebase.getString(fbdo, "/" + user +  "/switch3")) {
    if(fbdo.to<bool>() == true){
      digitalWrite(RELAY_PIN, HIGH);
      Serial.println("Relay On");
    }else{
      Serial.println("Relay Off");
      digitalWrite(RELAY_PIN, LOW);
    }
  }
}
